
# Dispute

Represents a [dispute](https://developer.squareup.com/docs/disputes-api/overview) a cardholder initiated with their bank.

## Structure

`Dispute`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `disputeId` | `?string` | Optional | The unique ID for this `Dispute`, generated by Square.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getDisputeId(): ?string | setDisputeId(?string disputeId): void |
| `id` | `?string` | Optional | The unique ID for this `Dispute`, generated by Square.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getId(): ?string | setId(?string id): void |
| `amountMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getAmountMoney(): ?Money | setAmountMoney(?Money amountMoney): void |
| `reason` | [`?string (DisputeReason)`](../../doc/models/dispute-reason.md) | Optional | The list of possible reasons why a cardholder might initiate a<br>dispute with their bank. | getReason(): ?string | setReason(?string reason): void |
| `state` | [`?string (DisputeState)`](../../doc/models/dispute-state.md) | Optional | The list of possible dispute states. | getState(): ?string | setState(?string state): void |
| `dueAt` | `?string` | Optional | The deadline by which the seller must respond to the dispute, in [RFC 3339 format](https://developer.squareup.com/docs/build-basics/common-data-types/working-with-dates).<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getDueAt(): ?string | setDueAt(?string dueAt): void |
| `disputedPayment` | [`?DisputedPayment`](../../doc/models/disputed-payment.md) | Optional | The payment the cardholder disputed. | getDisputedPayment(): ?DisputedPayment | setDisputedPayment(?DisputedPayment disputedPayment): void |
| `evidenceIds` | `?(string[])` | Optional | The IDs of the evidence associated with the dispute. | getEvidenceIds(): ?array | setEvidenceIds(?array evidenceIds): void |
| `cardBrand` | [`?string (CardBrand)`](../../doc/models/card-brand.md) | Optional | Indicates a card's brand, such as `VISA` or `MASTERCARD`. | getCardBrand(): ?string | setCardBrand(?string cardBrand): void |
| `createdAt` | `?string` | Optional | The timestamp when the dispute was created, in RFC 3339 format.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getCreatedAt(): ?string | setCreatedAt(?string createdAt): void |
| `updatedAt` | `?string` | Optional | The timestamp when the dispute was last updated, in RFC 3339 format.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getUpdatedAt(): ?string | setUpdatedAt(?string updatedAt): void |
| `brandDisputeId` | `?string` | Optional | The ID of the dispute in the card brand system, generated by the card brand.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getBrandDisputeId(): ?string | setBrandDisputeId(?string brandDisputeId): void |
| `reportedDate` | `?string` | Optional | The timestamp when the dispute was reported, in RFC 3339 format.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getReportedDate(): ?string | setReportedDate(?string reportedDate): void |
| `reportedAt` | `?string` | Optional | The timestamp when the dispute was reported, in RFC 3339 format.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getReportedAt(): ?string | setReportedAt(?string reportedAt): void |
| `version` | `?int` | Optional | The current version of the `Dispute`. | getVersion(): ?int | setVersion(?int version): void |
| `locationId` | `?string` | Optional | The ID of the location where the dispute originated.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `40` | getLocationId(): ?string | setLocationId(?string locationId): void |

## Example (as JSON)

```json
{
  "dispute_id": "dispute_id2",
  "id": "id0",
  "amount_money": {
    "amount": 186,
    "currency": "NGN"
  },
  "reason": "NOT_AS_DESCRIBED",
  "state": "PROCESSING"
}
```

